//
//  TWMenuOptionTableViewCell.m
//  Xarth
//
//  Created by Auston Stewart on 10/21/13.
//  Copyright (c) 2013 Justin.tv, Inc. All rights reserved.
//

#import "TWOptionTableViewCell.h"

NSString *const TWOptionTableViewCellReuseIdentifier = @"TWOptionTableViewCellReuseIdentifier";

@implementation TWOptionTableViewCell

- (void)setStandardOptionCellParameters
{
	self.accessoryType = UITableViewCellAccessoryNone;
	self.textLabel.adjustsFontSizeToFitWidth = YES;
	self.textLabel.minimumScaleFactor = .7f;
	self.adjustsImageTint = YES;
	self.adjustsAccessoryTint = NO;
	self.accessoryTintColor = [UIDevice currentDevice].isPhone ? [UIColor twitchOptionsAccessoryTintColor] : [UIColor twitchPurpleColor];
	if ([UIDevice currentDevice].isPad) {
		
		self.backgroundColor = [UIColor twitchOptionsCellBackgroundColorPadNormal];
		self.textLabel.textColor = [UIColor blackColor];
	}
	self.bottomSeparatorColor = [UIDevice currentDevice].isPhone ? [UIColor twitchOptionsSeparatorColorPhone] : [UIColor twitchOptionsSeparatorColorPad];
	self.showsBottomSeparator = YES;
	self.showSelection = NO;
}

- (void)commonInitialization
{
	[super commonInitialization];
	[self setStandardOptionCellParameters];
}

- (void)prepareForReuse
{
	[super prepareForReuse];
	[self setStandardOptionCellParameters];
	
	// Reset accessory padding
	self.accessoryPadding = UIEdgeInsetsMake(0.f, 10.f, 0.f, 10.f);
}

@end
